[#-------------- INCLUDE AND ASSIGN PART --------------]
[#-- Assigns: Is Content Available --]
[#assign hasDate = content.date?has_content]
[#assign hasTime = content.zeit?has_content]
[#assign hasDateEnd = content.dateEnd?has_content]
[#assign hasLocation = content.location?has_content]
[#assign hasDistrict = content.bezirk?has_content]
[#assign hasOrganizer = content.veranstalter?has_content]
[#assign hasLink = content.link?has_content]
[#assign hasMail = content.mail?has_content]
[#assign hasEventTitle = content.eventTitle?has_content]
[#assign hasComment = content.bemerkungen?has_content]

[#-- Assigns: Micro Format for Date&Time --]
[#if hasDate]
    [#assign microFormatDate = content.date?string("yyyy-MM-dd")]
[/#if]
[#if hasDateEnd]
    [#assign microFormatDateEnd = content.dateEnd?string("yyyy-MM-dd")]
[/#if]

[#-------------- RENDERING PART --------------]
[#-- Rendering: Event infoblock --]
<div class="vevent">
    <div class="date">
        [#if hasDate]
            <span class="month"><abbr title="${content.date?string("MMMM")}">${content.date?string("MMM")}</abbr></span>
            <span class="day">${content.date?string("dd")}<span>.</span></span>
        [/#if]
        [#if hasDateEnd]
            <span class="till">till</span>
            <span class="month d-end"><abbr title="${content.dateEnd?string("MMMM")}">${content.dateEnd?string("MMM")}</abbr></span>
            <span class="day d-end">${content.dateEnd?string("dd")}<span>.</span></span>
        [/#if]
    </div>

    <h2 class="summary">${content.eventTitle!'No "Event Title" is defined: Fill out the "Event Header"'}</h2>

    <dl>
        <dt>${i18n['event.date']}</dt>
        <dd>
            [#if hasDate]
                ${content.date?date?string.long}<span class="dtstart">${microFormatDate}</span>
            [#else]
                ${i18n['infoblock.no.event.date.error']}
            [/#if]
            [#if hasDateEnd] - ${content.dateEnd?date?string.long} <span class="dtend">${microFormatDateEnd}</span>[/#if]
        </dd>
    </dl>
    [#if hasTime]
        <dl>
            <dt>${i18n['event.time']}</dt>
            <dd>${content.zeit}</dd>
        </dl>
    [/#if]
    [#if hasDistrict]
        <dl>
            <dt>Bezirk</dt>
            <dd class="location">${content.bezirk}</dd>
        </dl>
    [/#if]
    [#if hasLocation]
        <dl>
            <dt>${i18n['event.location']}</dt>
            <dd class="location">${content.location}</dd>
        </dl>
    [/#if]
    [#if hasLink]
        <dl>
            <dt>${i18n['event.url']}</dt>
            <dd><a class="url" href="${cmsfn.externalLink(content, "link")}">${cmsfn.externalLinkTitle(content, "link", "linkTitle")}</a></dd>
        </dl>
    [/#if]
    [#if hasMail]
        <dl class="email">
            <dt>${i18n['contact.mail']}</dt>
            <dd class="value"><a href="mailto:${content.mail}">${content.mail}</a></dd>
        </dl>
    [/#if]
    [#if hasOrganizer]
        <dl>
            <dt>Veranstalter</dt>
            <dd class="location">${content.veranstalter}</dd>
        </dl>
    [/#if]
    [#if hasComment]
        <dl>
            <dt>Bemerkung</dt>
            <dd class="location">${content.bemerkungen}</dd>
        </dl>
    [/#if]
</div><!-- end vevent -->
