[#-------------- INCLUDE AND ASSIGN PART --------------]
[#-- Include: Global --]
[#include "/templating-kit/components/teasers/init.inc.ftl"]
[#include "/templating-kit/components/macros/pagination.ftl"]

[#-- Assigns: Get and check Latest Events --]
[#assign pager = model.pager]
[#assign eventsList = cmsfn.asContentMapList(pager.pageItems)!]
[#assign hasEventsList = eventsList?has_content]

[#-- Assigns: Macro for Item iteration --]
[#macro assignItemValues item]
[#-- Assigns: Get Content from List Item--]
    [#assign itemTitle = item.title!item.@name]
    [#assign itemText = stkfn.abbreviateString(item.abstract!, 100)]
    [#assign itemLink = cmsfn.link(item)!]
    [#assign itemDate = item.date!]
    [#assign itemTime = item.zeit!]
    [#assign itemLocation = item.location!]
    [#if item.bezirk?has_content]
        [#assign itemLocation = "<strong>" + item.bezirk + ":</strong> " + itemLocation]
    [/#if]
[#-- Assigns: Is Content Available of Item--]
    [#assign hasText = itemText?has_content]
    [#assign hasDate = itemDate?has_content]
    [#assign hasTime = itemTime?has_content]
    [#assign hasLocation = itemLocation?has_content]
[/#macro]

[#-------------- RENDERING PART --------------]
[#-- Rendering: Latest Events --]
<div class="${divClass}" ${divID}>

    <${headingLevel}>All events</${headingLevel}>

<div id="event-pager">
    <h5>${i18n['eventsOverview.eventPager.title']}</h5>
    <ul>
        <li class="prev"><a href="${model.prevLink.href}" title="${i18n['eventsOverview.eventPager.prevMonth']}">${model.prevLink.title}</a></li>
        <li class="next"><a href="${model.nextLink.href}" title="${i18n['eventsOverview.eventPager.nextMonth']}">${model.nextLink.title}</a></li>
    </ul>
</div><!-- #event-pager -->

[#-- Macro: Pager --]
[@pagination pager "top" /]

[#if hasEventsList]
<ul>
    [#list eventsList as item]
    [#-- Macro: Item Assigns --]
        [@assignItemValues item=item/]

    [#-- Rendering: List Item rendering --]
        <li>
            [#if hasDate]
                <div class="date">
                    <span class="month"><abbr title="${itemDate?string("MMMM")}">${itemDate?string("MMM")}</abbr></span>
                    <span class="day">${itemDate?string("d")}<span>.</span></span>
                </div>
            [/#if]

            <h3>
                <a href="${itemLink}">${itemTitle}</a>
            </h3>

            [#if hasLocation || hasTime]
                <ul class="event-data">
                    [#if hasLocation]
                        <li class="location">${itemLocation}</li>
                    [/#if]
                    [#if hasTime]
                        <li class="time">${itemTime}</li>
                    [#else]
                        <li class="time">&nbsp;</li>
                    [/#if]
                </ul>
            [/#if]
        </li>
    [/#list]
</ul>
[#else]
<ul>
    <p>${i18n['eventsList.noResults']}</p>
</ul>
[/#if]
</div><!-- end ${divClass} -->
[#-- Macro: Pager --]
[@pagination pager "bottom"/]
