package info.magnolia.projects.lm.templates.components;

import info.magnolia.context.MgnlContext;
import info.magnolia.rendering.model.RenderingModel;
import info.magnolia.rendering.model.RenderingModelImpl;
import info.magnolia.rendering.template.TemplateDefinition;

import javax.inject.Inject;
import javax.jcr.Node;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("unused")
public class LmCalendarRangeModel<RD extends TemplateDefinition> extends RenderingModelImpl<RD> implements RenderingModel<RD> {

    private static final Logger log = LoggerFactory.getLogger(LmCalendarRangeModel.class);

    @Inject
    public LmCalendarRangeModel(Node content, RD definition, RenderingModel<?> parent) {
        super(content, definition, parent);
    }

    public String getDateFrom() {
        return StringUtils.isNotEmpty(MgnlContext.getParameter("fromDate")) ? MgnlContext.getParameter("fromDate") : "";
    }

    public String getDateTo() {
        return StringUtils.isNotEmpty(MgnlContext.getParameter("toDate")) ? MgnlContext.getParameter("toDate") : "";
    }
}
