package info.magnolia.projects.lm.actions;

import info.magnolia.event.EventBus;
import info.magnolia.projects.lm.util.PageUtil;
import info.magnolia.ui.api.context.UiContext;
import info.magnolia.ui.framework.action.DeleteItemAction;
import info.magnolia.ui.framework.action.DeleteItemActionDefinition;
import info.magnolia.ui.vaadin.integration.jcr.JcrItemAdapter;

import javax.inject.Named;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteEventItemAction extends DeleteItemAction {

    private static final Logger log = LoggerFactory.getLogger(DeleteEventItemAction.class);

    JcrItemAdapter eventItem;

    public DeleteEventItemAction(DeleteItemActionDefinition definition, JcrItemAdapter item, @Named("admincentral") EventBus eventBus, UiContext uiContext) {
        super(definition, item, eventBus, uiContext);
    }

    @Override
    protected void executeAfterConfirmation() {
        Node pageNode = PageUtil.findEventPage(eventItem.getItemProperty("id").toString());

        if (pageNode != null) {
            // delete web page
            try {
                Session session = pageNode.getSession();
                pageNode.remove();
                session.save();
            } catch (RepositoryException e) {
                log.error("Problem while removing website page: " + e.getMessage());
            }
        }
        // delete item from content app
        super.executeAfterConfirmation();
    }
}
