module Action
  module ActionRun
    def do_action
      utils = File.join(NFSMP, "scripte/lib/utils.rb")
      require utils
      @@sysdir="/mnt/system"
      puts "upgrading OS ..."
      disk_layout = Utils.new.show_disk_layout
      Utils.new.make_device("/", disk_layout)
      Utils.new.set_part(disk_layout)
      Utils.new.format_part(disk_layout)
      Utils.new.disk_mount(disk_layout)
      clone(disk_layout)
      Utils.new.disk_umount(disk_layout)
    end

    # TODO: OS From /proc/cmdline
    def clone(_device_layout)
      FileUtils.mkdir(File.join(@@sysdir, "dev")) unless File.directory?(File.join(@@sysdir, "dev"))
      puts "Start cloning ..."
      raise "clone error" unless system("/usr/bin/rsync -azH --delete #{NFSMP}/gentoo/i686/latest/ #{@@sysdir}/ --exclude-from=#{NFSMP}/exclude")
      puts "Install Bootloader"
      FileUtils.mkdir(File.join(@@sysdir, "proc")) unless File.directory?(File.join(@@sysdir, "proc"))
      raise "proc mount failed" unless system("/bin/mount --bind /proc #{@@sysdir}/proc")
      raise "dev mount failed" unless system("/bin/mount --bind /dev  #{@@sysdir}/dev")
      system("chroot #{@@sysdir} grep -v rootfs /proc/mounts > #{@@sysdir}/etc/mtab")
      raise "grub install failed" unless system("/usr/bin/chroot #{@@sysdir} /sbin/grub-install #{_device_layout[:device]}")
      hostname = `echo $HOSTNAME`
      puts "Set Hostname to #{hostname}"
      raise "can not set hostname" unless system("echo hostname=\"$HOSTNAME\" >#{@@sysdir}/etc/conf.d/hostname")
      puts "umount filesystems"
      system("/bin/umount #{@@sysdir}/proc")
      system("/bin/umount #{@@sysdir}/dev")
    end
  end
end
