module Action
  module ActionRun
    def do_action
      utils = File.join(NFSMP, "scripte/lib/utils.rb")
      require utils
      @@sysdir="/mnt/system"
      puts "Write Image ..."
      disk_layout = Utils.new.show_disk_layout
      Utils.new.disk_mount(disk_layout)
      push
      Utils.new.disk_umount(disk_layout)
    end

    # TODO: OS From /proc/cmdline
    def push
      require 'time'
      t = Time.now
      date = t.strftime("%Y") + "-" + t.strftime("%m") + "-" + t.strftime("%d") + "," + t.strftime("%R:%S")
      snap_name = NFSMP + "/gentoo/i686/" + date

      if File.symlink?(File.join(NFSMP, "gentoo/i686/latest"))
        filepath = File.readlink(File.join(NFSMP, "gentoo/i686/latest"))
      else
        filepath = nil
      end
      puts "Start pushing ..."
      if not filepath.nil?
        raise "push error" unless system("/usr/bin/rsync -azH --delete #{@@sysdir}/ #{snap_name}/ --link-dest=#{File.join(NFSMP, 'gentoo/i686/', filepath)} --exclude-from=#{File.join(NFSMP, '/exclude.push')}")
      else
        raise "push error" unless system("/usr/bin/rsync -azH --delete #{@@sysdir}/ #{snap_name}/ --exclude-from=#{File.join(NFSMP, 'exclude.push')}")
      end

      File.delete(File.join(NFSMP, 'gentoo/i686/latest')) unless filepath.nil?
      begin
        Dir.chdir(File.join(NFSMP, 'gentoo/i686'))
        File.symlink(date, "latest")
      rescue => exc
        raise "latest link failed: #{exc}"
      end
    end
  end
end

