#!/usr/bin/ruby

class Utils
  def initialize
    require 'yaml'
  end
  def show_disk_layout
    partition = YAML.load_file(File.join(NFSMP, "scripte/disk.layout"))
    partition
  end
  def disk_info(_disk)
    # Disk Information
    di = []
    _disk.each do |key,value|
      if key == :device
        layout = {
          :device => value
        }
        di << layout
        next
      end
      s_space, e_space, partnum, filesystem, type = value.split(/,/)
      layout = {
        :device => key.to_s,
        :start_space => s_space,
        :end_space => e_space,
        :partition => partnum,
        :filesystem => filesystem,
        :type => type
      }
      di << layout
    end
    di
  end
  def disk_mount(_disk_layout)
    FileUtils.mkdir(@@sysdir) unless File.directory?(@@sysdir)
    disk_information = disk_info(_disk_layout)

    disk_information.each do |h|
      next unless h[:device] == "root"
      raise "can not mount #{_disk_layout[:device]}#{h[:partition]} to #{@@sysdir}" unless system("mount #{_disk_layout[:device]}#{h[:partition]} -t #{h[:filesystem]} #{@@sysdir}")
    end

    # mount rest
    disk_information.each do |h|
      next if h[:device] == "root"
      next if h[:device].include?("/")
      unless h[:device] == "swap"
        FileUtils.mkdir(File.join(@@sysdir,h[:device])) unless File.directory?(File.join(@@sysdir, h[:device]))
        raise "can not mount #{_disk_layout[:device]}#{h[:partition]} to #{@@sysdir}/#{h[:device]}" unless system("mount #{_disk_layout[:device]}#{h[:partition]} -t #{h[:filesystem]} #{File.join(@@sysdir, h[:device])}")
      else
        raise "can not mount #{_disk_layout[:device]}#{h[:partition]} to swap" unless system("/sbin/swapon #{_disk_layout[:device]}#{h[:partition]}")
      end
    end
  end
  def disk_umount(_disk_layout)
    Dir.chdir("/")
    disk_information = disk_info(_disk_layout)

    # mount rest
    disk_information.each do |h|
      next if h[:device] == "root"
      next if h[:device].include?("/")
      unless h[:device] == "swap"
        raise "can not umount #{_disk_layout[:device]}#{h[:partition]}" unless system("umount #{File.join(@@sysdir, h[:device])}")
      else
        raise "can not umount #{_disk_layout[:device]}#{h[:partition]} swap" unless system("/sbin/swapoff #{_disk_layout[:device]}#{h[:partition]}")
      end
    end
    disk_information.each do |h|
      next unless h[:device] == "root"
      raise "can not umount #{_disk_layout[:device]}#{h[:partition]} to #{@@sysdir}" unless system("umount #{@@sysdir}")
    end
  end
  def set_part(_disk_layout)
    disk_information = disk_info(_disk_layout)
    # partition clear
    #unless system("/bin/dd if=/dev/zero of=#{_disk_layout[:device]} count=600 bs=512")
    #  puts "dd error"
    #  exit
    #end
    parted = "/usr/sbin/parted"
    raise "partition error, mklabel #{_disk_layout[:device]} - abort" unless system(parted + " -s #{_disk_layout[:device]} mklabel msdos")

    disk_information.each do |h|
      next if h[:device].include?("/")
      raise "can not set partition #{_disk_layout[:device]}#{h[:partition]}" unless system(parted + " -s #{_disk_layout[:device]} mkpart #{h[:type]} #{h[:filesystem]} #{h[:start_space]} #{h[:end_space]}")
    end
  end
  def format_part(_disk_layout)
    disk_information = disk_info(_disk_layout)

    puts "create filesystems"
    disk_information.each do |h|
      next if h[:device].include?("/")
      unless h[:device] == "swap"
        raise "Format #{h[:device]} failed" unless system("/sbin/mkfs.#{h[:filesystem]} #{_disk_layout[:device]}#{h[:partition]} -L #{h[:device]} 1>&2> /dev/null")
      else
        raise "Format #{h[:device]} failed" unless system("/sbin/mkswap #{_disk_layout[:device]}#{h[:partition]} -L #{h[:device]} 1>&1 >/dev/null")
      end
    end
  end
  def make_device(_path, _disk_layout)
    mknod="/bin/mknod"
    count = 0
    5.times do
      count += 1
      unless File.exists?((File.join(_path, _disk_layout[:device]) + count.to_s))
        raise "make device error" unless  system("#{mknod} #{File.join(_path, _disk_layout[:device])}#{count} b 8 #{count}")
      end
    end
    system("#{mknod} #{File.join(_path, _disk_layout[:device])} b 8 0") unless File.exists?(File.join(_path, _disk_layout[:device]))
    system("#{mknod} #{File.join(_path, '/dev/console')} c 5 1") unless File.exists?(File.join(_path, "dev/console"))
  end
end
