module Action
  module ActionRun
    def do_action
      utils = File.join(NFSMP, "scripte/lib/utils.rb")
      require utils
      @@sysdir="/mnt/system"
      puts "upgrading OS ..."
      disk_layout = Utils.new.show_disk_layout
      Utils.new.disk_mount(disk_layout)
      sync(disk_layout)
      Utils.new.disk_umount(disk_layout)
    end

    # TODO: OS From /proc/cmdline
    def sync(_disk_layout)
      FileUtils.mkdir("#{File.join(@@sysdir, 'dev')}") unless File.directory?("#{File.join(@@sysdir, 'dev')}")
      raise "latest link not found" unless File.symlink?(File.join(NFSMP, "gentoo/i686/latest"))
      filepath = File.readlink(File.join(NFSMP, "gentoo/i686/latest"))

      puts "Start sync ..."
      raise "Sync error" unless system("/usr/bin/rsync -azH --delete #{File.join(NFSMP, 'gentoo/i686/', filepath)}/ #{@@sysdir}/ --exclude-from=#{File.join(NFSMP, 'exclude')}")
      hostname=`echo $HOSTNAME`
      puts "Set Hostname to #{hostname}"
      raise "can not set hostname" unless system("echo hostname=\"$HOSTNAME\" >#{File.join(@@sysdir,'etc/conf.d/hostname')}")
    end
  end
end
