package com.hemju.biborder;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Helmut Juskewycz, <hjuskewycz - at - hemju.com>
 */
public class Main {

  /**
   * The program needs certain arguments too work
   *
   * 1. "-f" (optional) indicates whether the algo sorts all entries or just the footnote references
   * 2. source path (e.g. "sample4.txt")
   * 3. dest path (optional) (e.g. out.txt) indicates whether the standard output should be used (when not specified)
   *    or if the output should be written to a file
   *
   * examples:
   *
   * - java xxx -f sample.txt out.txt
   * - java sample.txt
   * - java sample.txt out.txt
   *
   * Using JVM arguments can save some seconds. Using -Xms512m or -Xms1024m helped about 1-2 sec (the buffer size can
   * be bigger then).
   *
   * On my machine both algos take about 5 seconds.
   *
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    OutputStream out = null;
    try {
      OrderStrategy orderer = null;
      String input = null;

      int index = 0;

      if ("-f".equals(args[0])) {
        index = 1;
        orderer = new OrderAll();
      } else {
        orderer = new OrderBibRef();
      }

      input = args[index];
      out = (args.length == (index + 2)) ? new FileOutputStream(args[index + 1]) : System.out;

      BibReorder br = new BibReorder(input, orderer);
      br.reorder(out);

    } catch (FileNotFoundException ex) {
      Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
    } finally {
      if (out != null) {
        try {
          out.close();
        } catch (IOException ex) {
          Logger.getLogger(BibReorder.class.getName()).log(Level.SEVERE, null, ex);
        }
      }
    }
  }
}
