package de.wartala.meinevideos;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;

import org.trails.descriptor.annotation.PropertyDescriptor;

@Entity
public class Actor {
    private Integer id;
    private String name;
    private Date birthday;
    
    @PropertyDescriptor(index=0)
    @Id(generate=GeneratorType.AUTO)
    public Integer getId() {
        return id;
    }
    
    public void setId(Integer id) {
        this.id = id;
    }
    
    @PropertyDescriptor(index=1)
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    @PropertyDescriptor(index=2,format="dd.MM.yyyy",displayName="Geburtstag")
    public Date getBirthday() {
        return birthday;
    }
    
    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }
    
    public String toString() {
        return this.getName();
    }    
}
