/* This file is part of the KDE project
   Copyright (C) 2003-2004 Jarosław Staniek <staniek@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KDEWIN_SYS_TIMES_H
#define KDEWIN_SYS_TIMES_H

// include everywhere
#include <sys/types.h>

#include <machine/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(__clock_t_defined) && !defined(_CLOCK_T_DEFINED)
typedef _CLOCK_T_ clock_t;
#define __clock_t_defined
#endif

struct tms {
	clock_t	tms_utime;		/* user time */
	clock_t	tms_stime;		/* system time */
	clock_t	tms_cutime;		/* user time, children */
	clock_t	tms_cstime;		/* system time, children */
};

KDEWIN_EXPORT clock_t times(struct tms *);

#ifdef __cplusplus
}
#endif

#endif	// KDEWIN_SYS_TIMES_H
