import base
import os
import sys
import info

class subinfo(info.infoclass):
    def setTargets( self ):
        for ver in ['4.6']:
            self.svnTargets[ ver ] = '[git]kde:kstars|%s|' % ver
            
        self.svnTargets['gitHEAD'] = '[git]kde:kstars'
        self.defaultTarget = 'gitHEAD'


    def setDependencies( self ):
        self.buildDependencies['win32libs-bin/cfitsio'] = 'default'
        self.dependencies['kde/kde-runtime'] = 'default'
        self.dependencies['win32libs-bin/libnova'] = 'default'
        self.dependencies['kdesupport/eigen2'] = 'default'

from Package.CMakePackageBase import *

class Package(CMakePackageBase):
    def __init__( self ):
        self.subinfo = subinfo()
        CMakePackageBase.__init__( self )

if __name__ == '__main__':
    Package().execute()
