/* This file is part of the KDE libraries
 *
 * Copyright (C) 1997 Martin Jones (mjones@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KCOLORVALUESELECTOR_H
#define KCOLORVALUESELECTOR_H

#include "kselector.h"
#include "kcolorchoosermode.h"
#include <kdelibs4support_export.h>
#include <QPixmap>

class KDELIBS4SUPPORT_DEPRECATED_EXPORT KColorValueSelector : public KSelector
{
    Q_OBJECT
    Q_PROPERTY(int hue READ hue WRITE setHue)
    Q_PROPERTY(int saturation READ saturation WRITE setSaturation)
    Q_PROPERTY(int colorValue READ colorValue WRITE setColorValue)
public:
    /**
     * Constructs a widget for color selection.
     */
    KDELIBS4SUPPORT_DEPRECATED explicit KColorValueSelector(QWidget *parent = nullptr);
    /**
     * Constructs a widget for color selection with a given orientation
     */
    KDELIBS4SUPPORT_DEPRECATED explicit KColorValueSelector(Qt::Orientation o, QWidget *parent = nullptr);

    ~KColorValueSelector() override;

    /**
     * Updates the widget's contents.
     */
    void updateContents();

    /**
     * Returns the current hue value.
     *
     * @return               The hue value (0-359)
     */
    int hue() const;

    /**
     * Sets the hue value. Doesn't automatically update the widget;
     * you have to call updateContents manually.
     *
     * @param     hue         Sets the hue value (0-359)
     */
    void setHue(int hue);

    /**
     * Returns the current saturation value.
     *
     * @return                The saturation value (0-255)
     */
    int saturation() const;

    /**
     * Sets the saturation value. Doesn't automatically update the widget;
     * you have to call updateContents manually.
     *
     * @param     saturation      Sets the saturation value (0-255)
     */
    void setSaturation(int saturation);

    /**
     * Returns the current color value.
     *
     * @return                The color value (0-255)
     */
    int colorValue() const;

    /**
     * Sets the color value. Doesn't automatically update the widget;
     * you have to call updateContents manually.
     *
     * @param     colorValue      Sets the color value (0-255)
     */
    void setColorValue(int colorValue);

    /**
     * Sets the chooser mode. Doesn't automatically update the widget;
     * you have to call updateContents manually.
     *
     * @param     chooserMode     Sets the chooser mode (one of the KColorChooserMode constants)
     */
    void setChooserMode(KColorChooserMode chooserMode);

    /**
     * Returns the current chooser mode.
     *
     * @return                The chooser mode (one of the KColorChooserMode constants)
     */
    KColorChooserMode chooserMode() const;

protected:
    /**
     * Draws the contents of the widget on a pixmap,
     * which is used for buffering.
     */
    virtual void drawPalette(QPixmap *pixmap);
    void resizeEvent(QResizeEvent *) override;

    /**
     * Reimplemented from KSelector. The drawing is
     * buffered in a pixmap here. As real drawing
     * routine, drawPalette() is used.
     */
    void drawContents(QPainter *painter) override;

private:
    class Private;
    friend class Private;

    Private *const d;

    Q_DISABLE_COPY(KColorValueSelector)
};

#endif /* KCOLORVALUESELECTOR_H */

