# Copyright (c) 2005 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de> 
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""Raster Layer Properties dialog"""

__version__ = "$Revision: 1.3 $"
# $Source: /thubanrepository/thuban/Thuban/UI/rasterlayerproperties.py,v $
# $Id: rasterlayerproperties.py,v 1.3 2005/03/23 15:30:27 jonathan Exp $

from wxPython.wx import *

from Thuban import _
from Thuban.UI.layerproperties import LayerProperties
from Thuban.Model.resource import has_gdal_support, gdal_support_status

from Thuban.version import versions

ID_RB_MASK = 4002

class RasterLayerProperties(LayerProperties):

    def __init__(self, parent, name, layer, *args, **kw):
        LayerProperties.__init__(self, parent, name, layer)

        self.old_state = {}
        self.old_state["mask_type"] = layer.MaskType()

        LayerProperties.dialog_layout(self)

    def dialog_layout(self, panel, panelBox):

        info = self.layer.ImageInfo()

        if info is None:
            panelBox.Add(
                wxStaticText(panel, -1, 
                _("GDAL image information unavailable. See About box for details.")),
                0, wxALIGN_LEFT | wxALL, 4)
            return

        
        # Bounding Box
        bbox = self.layer.LatLongBoundingBox()
        if bbox is None:
            text = _("Extent (lat-lon): None")
        else:
            text = _("Extent (lat-lon): (%g, %g, %g, %g)") % tuple(bbox)

        panelBox.Add(wxStaticText(panel, -1, text), 0, wxALIGN_LEFT|wxALL, 4)

        rasterBox = wxStaticBoxSizer(wxStaticBox(panel, -1, 
                    _("Image Properties")), wxVERTICAL)


        rasterBox.Add(
            wxStaticText(panel, -1, 
            _("Source: %s") % self.layer.GetImageFilename()),
            0, wxALIGN_LEFT | wxALL, 4)

        infoBox = wxBoxSizer(wxHORIZONTAL)

        nBands = info["nBands"]

        self.usePalIndex = nBands == 1
        
        infoBox.Add(
            wxStaticText(panel, -1, _("Driver: %s") % info["Driver"]),
            0, wxALIGN_LEFT | wxRIGHT, 10)
        infoBox.Add(
            wxStaticText(panel, -1, _("Size: %ix%i") % info["Size"]),
            0, wxALIGN_LEFT | wxRIGHT, 10)
        infoBox.Add(
            wxStaticText(panel, -1, _("Number of Bands: %i") % nBands),
            0, wxALIGN_LEFT | wxRIGHT, 0)

        rasterBox.Add(infoBox, 0, wxALIGN_LEFT|wxALL, 4)

        # Mask 

        maskBox = wxBoxSizer(wxHORIZONTAL)

        if versions['wxPython-tuple'] < (2,5,3):
            choices = ["None", "Bitmap", 
                       "Alpha (Not support by wxPython %s)" % \
                       versions['wxPython']]
        else:
            choices = ["None", "Bitmap", "Alpha"]

        self.maskRadioBox = wxRadioBox(panel, ID_RB_MASK, _("Mask Type"), 
                            choices=choices)
        #self.maskCB = wxCheckBox(panel, -1, _("Use Mask"))
        maskBox.Add(self.maskRadioBox, 0, wxRIGHT, 10)

        self.opBox = wxBoxSizer(wxHORIZONTAL)
        self.opSpinLabel = wxStaticText(panel, -1, _("Opacity:"))
        self.opBox.Add(self.opSpinLabel, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT, 4)
        self.opSpin = wxSpinCtrl(panel, -1, 
                                 str(self.layer.Opacity()*255),
                                 initial = self.layer.Opacity()*255,
                                 min=0, max=255)
        self.opBox.Add(self.opSpin, 0, wxALL, 4)
        maskBox.Add(self.opBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4)

        rasterBox.Add(maskBox, 0, wxALL, 4)
        #rasterBox.Add(opBox, 0, wxALL, 4)

        panelBox.Add(rasterBox, 1, wxGROW | wxALL, 4)

        self.maskRadioBox.SetSelection(self.old_state["mask_type"])

        self.OnMaskSelect(None)

        EVT_RADIOBOX(self, ID_RB_MASK, self.OnMaskSelect)

    def OnTry(self, event):
        self.set_state()

    def OnOK(self, event):
        if self.set_state(): 
            self.Close()

    def OnRevert(self, event):
        self.maskRadioBox.SetSelection(self.old_state["mask_type"])
        self.set_state()

    def OnMaskSelect(self, event):
        allowOpacity = self.maskRadioBox.GetSelection()==2
        self.opSpin.Enable(allowOpacity)
        self.opSpinLabel.Enable(allowOpacity)

    def set_state(self):
        self.layer.SetMaskType(self.maskRadioBox.GetSelection())
        self.layer.SetOpacity(self.opSpin.GetValue()/255.0)
        return True
