# Copyright (c) 2003 by Intevation GmbH
# Authors:
# Jan-Oliver Wagnber <jan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.2 $"

import sys

from wxPython.wx import *

from Thuban import _

class ExceptionDialog(wxDialog):

    """The exception dialog shows the exception message and then allows
    to either proceed with the application or to exit it. In the
    latter case, sys.exit(1) is applied immediately.
    """

    def __init__(self, parent, message, title = _('Thuban: Internal Error')):
        wxDialog.__init__(self, parent, -1, title,
                          wxDefaultPosition,
                          style = wxRESIZE_BORDER|wxCAPTION|wxDIALOG_MODAL)

        self.parent = parent
        self.dialog_layout(message)
        
    def dialog_layout(self, message):
        top_box = wxBoxSizer(wxVERTICAL)

        textBox = wxTextCtrl(self, -1, message, 
            style=wxTE_READONLY|wxTE_MULTILINE|wxTE_LINEWRAP)
        w, h = (500, 300)
        textBox.SetSizeHints(w, h)
        textBox.SetSize((w, h))

        top_box.Add(textBox, 1, wxEXPAND|wxALL, 10)

        box = wxBoxSizer(wxHORIZONTAL)
        box.Add(wxButton(self, wxID_OK, _("Proceed")), 0, wxALL, 4) 
        box.Add(wxButton(self, wxID_CANCEL, _("Exit Thuban now")), 0, wxALL, 4) 
        top_box.Add(box, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 10)

        EVT_BUTTON(self, wxID_OK, self.OnOK)
        EVT_BUTTON(self, wxID_CANCEL, self.OnExit)

        self.SetAutoLayout(True)
        self.SetSizer(top_box)
        top_box.Fit(self)
        top_box.SetSizeHints(self)

    def OnOK(self, event):
        self.EndModal(wxID_OK)

    def OnExit(self, event):
        sys.exit(1)

def run_exception_dialog(parent, message, title = _('Thuban: Internal Error')):
    dialog = ExceptionDialog(parent, message, title)
    dialog.ShowModal()
    dialog.Destroy()
