# Copyright (c) 2004 by Intevation GmbH
# Authors:
# Frank Koormann <frank@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.


"""Dialogs for alternative paths (path recovery).

   AltPathFileDialog:    File dialog to specify alterative path.
   AltPathConfirmDialog: Confirm or cancel alternative path suggestion.
"""

from Thuban import _

from wxPython.wx import wxFileDialog, wxMessageDialog, wxOPEN, \
                        wxYES_NO, wxYES_DEFAULT, wxICON_INFORMATION, \
                        wxID_OK, wxID_YES

import os

class AltPathFileDialog(wxFileDialog):

    def __init__(self, filename):
        msg = _("Select an alternative data file for %s" % \
                        os.path.basename(filename))
         
        wxFileDialog.__init__(self, None, 
                           msg, 
                           os.path.dirname(filename), 
                           os.path.basename(filename),
                           _("Shapefiles (*.shp)") + "|*.shp;*.SHP|" +
                           _("All Files (*.*)") + "|*.*",
                           wxOPEN)

    def RunDialog(self):
        val = self.ShowModal()
        self.Destroy()
        if val == wxID_OK:
            return self.GetPaths()[0]
        else:
            return None

class AltPathConfirmDialog(wxMessageDialog):

    def __init__(self, filename):
        self.filename = filename
        msg = _("Found the following as an alternative for %s.\n%s\n\n Please confirm with Yes or select alternative with No." % (os.path.basename(filename), filename))
         
        wxMessageDialog.__init__(self, None, msg, _("Alternative Path"),
                        wxYES_NO|wxYES_DEFAULT|wxICON_INFORMATION)

    def RunDialog(self):
        val = self.ShowModal()
        self.Destroy()
        if val == wxID_YES:
            return self.filename
        else:
            dlg = AltPathFileDialog(self.filename)
            fname = dlg.RunDialog()
            return fname   
