# Copyright (c) 2001-2005 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
# Bernhard Reiter <bernhard@intevation.de>
# Silke Reimer <silke@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""The About Box"""

__version__ = "$Revision: 1.23 $"
# $Source: /thubanrepository/thuban/Thuban/UI/about.py,v $
# $Id: about.py,v 1.23 2005/07/05 20:04:35 bh Exp $

from wxPython.wx import *

from locale import getdefaultlocale

from Thuban import _, internal_from_unicode
from Thuban.version import versions
from Thuban.Model.resource import gdal_support_status

from Thuban.UI.extensionregistry import ext_registry

class About(wxDialog):

    def __init__(self, parent):
        wxDialog.__init__(self, parent, -1, _("About Thuban"),
            style = wxDEFAULT_DIALOG_STYLE
                  | wxSYSTEM_MENU
                  | wxMINIMIZE_BOX
                  | wxMAXIMIZE_BOX
                  | wxRESIZE_BORDER,
            size = (400, 250))

        # Note: The source code is in ASCII, so we escape some
        # characters to get byte strings in latin1.
        lead_developer = 'Bernhard Herzog'
        developers = [ 'Jonathan Coles',
                       'Frank Koormann',
                       internal_from_unicode(u'Martin M\xfcller'),
                       'Bernhard Reiter',
                       'Jan-Oliver Wagner' ]
        translators = [ ( _('French'), 'Daniel Calvelo Aros' ),
                        ( _('German'),
                          internal_from_unicode(u'Bj\xf6rn Broscheit')),
                        ( _('Hungarian'), 'Norbert Solymosi'),
                        ( _('Italian'), 'Maurizio Napolitano'),
                        ( _('Portuguese (Brazilian)'), 'Eduardo Patto Kanegae'),
                        ( _('Russian'), 'Alex Shevlakov'),
                        ( _('Spanish'), 'Daniel Calvelo Aros') ]
        other_contributors = [ 'Jonathan Byron',
                               'Ole Rahn',
                               'Silke Reimer' ]
        dyn_modules = [ ('wxPython', versions['wxPython']),
                        ('Python',   versions['python']),
                        ('PySQLite', versions['pysqlite']),
                        ('SQLite',  versions['sqlite']),
                        ('GDAL', versions.get('gdal', _('- not available'))),
                        ('psycopg', versions.get('psycopg',
                                                 _('- not available')))]
        direct_modules = [ \
                ('GTK',      versions.get('gtk', _('- not available'))),
                ('proj',     versions['proj']) ]

        text = 'Thuban %s\n\n' % versions['thuban-long']

        text += _('Currently using:\n')

        for name, version in dyn_modules:
            text+= '\t%s %s\n' % (name, version)
        text += '\n'

        if gdal_support_status:
            text += gdal_support_status + "\n\n"

        text += _('Compiled for:\n')

        for name, version in direct_modules:
            text+= '\t%s %s\n' % (name, version)
        text += '\n'

        text += _('Extensions:\n')
        if ext_registry:
            for ext in ext_registry:
                text += '\t%s %s\n' % (ext.name, ext.version)
        else:
            text += _('\tNone registered.\n')
        text += '\n'

        text += _('Lead Developer:\n')
        text += '\t%s\n\n' % lead_developer

        text += _('Developers:\n')
        for name in developers:
            text += '\t%s\n' % name
        text += '\n'

        text += _('Translators:\n')
        for lang, name in translators:
            text += '\t%s: %s\n' % (lang, name)
        text += '\n'

        text += _('Other Contributors:\n')
        for name in other_contributors:
            text += '\t%s\n' % name
        text += '\n'

        text += \
            _("Questions and comments can be sent to the following addresses:\n"
            "\tGeneral list (public):\n\t\t<thuban-list@intevation.de>\n"
            "\tDevelopers list (public):\n\t\t<thuban-devel@intevation.de>\n"
            "\tThuban team at Intevation:\n\t\t<thuban@intevation.de>\n"
            )

        text += '\n\n'

        text += _("Details on the registered extensions:\n\n")

        if ext_registry:
            for ext in ext_registry:
                text += '%s %s:\n' % (ext.name, ext.version)
                text += _('Copyright %s\n') % ext.copyright
                text += _('Authors:\n')
                for author in ext.authors:
                    text+= '\t%s\n' % author
                text += ext.desc
                text += '\n'
                text += 'Status: %s' % ext.status
                text += '\n\n'
        else:
            text += _('\tNone registered.\n')

        self.text = text

        text_title = wxStaticText(self, -1, 
            _("Thuban is a program for exploring geographic data.\n\n") +
            "Copyright 2001-2005 Intevation GmbH.\n" +
            _("Thuban is licensed under the GNU GPL"),
                                  style=wxST_NO_AUTORESIZE|wxALIGN_CENTRE)

        textBox = wxTextCtrl(self, -1, text, 
            style=wxTE_READONLY|wxTE_MULTILINE|wxTE_LINEWRAP)
        w, h = (300, 150)
        textBox.SetSizeHints(w, h)
        textBox.SetSize((w, h))

        button_close = wxButton(self, wxID_CANCEL, _("Close"))
        button_close.SetDefault()

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(text_title, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 10)
        sizer.Add(textBox, 1, wxALL|wxEXPAND, 10)
        sizer.Add(button_close, 0, wxALL|wxALIGN_RIGHT, 10)

        self.SetAutoLayout(True)
        self.SetSizer(sizer)
        sizer.Fit(self)
        sizer.SetSizeHints(self)
        self.Layout()

        EVT_BUTTON(self, wxID_CANCEL, self.OnCancel)

    def OnCancel(self, event):
        self.EndModal(wxID_CANCEL)
