# Copyright (c) 2004 by Intevation GmbH
# Authors:
# Martin Schulze <joey@infodrom.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""
Information dialog to display various information about a WMS layer.

class wmsInfoDialog(ThubanFrame):
    __init__

    dialog_layout(text)

    calcText(layer)
    
"""

__version__ = "$Revision: 1.3 $"
# $Source: /thubanrepository/thuban/Extensions/wms/infodialog.py,v $
# $Id: infodialog.py,v 1.3 2005/02/06 16:47:34 joey Exp $

from Thuban import _
from Thuban.UI.dialogs import ThubanFrame

from wxPython.wx import wxBoxSizer, wxTextCtrl, wxVERTICAL, \
    wxHORIZONTAL, wxTE_READONLY, wxTE_MULTILINE, wxTE_LINEWRAP, \
    wxEXPAND, wxALL, wxButton, wxALIGN_CENTER_HORIZONTAL, wxID_OK, \
    EVT_BUTTON


class wmsInfoDialog(ThubanFrame):
    """
    Representation for a simple information dialog

    This dialog will display the title of the WMS resource
    """

    def __init__(self, parent, name, layer, *args, **kw):
        """
        Build the information dialog
        """
        title = _("WMS Information")
        ThubanFrame.__init__(self, parent, name, title)

        self.dialog_layout(self.calcText(layer))


    def dialog_layout(self, text):
        """
        Set up the information dialog
        """

        vbox = wxBoxSizer(wxVERTICAL)

        textBox = wxTextCtrl(self, -1, text,
                             style=wxTE_READONLY|wxTE_MULTILINE|wxTE_LINEWRAP)
        w, h = (500, 300)
        textBox.SetSizeHints(w, h)
        textBox.SetSize((w, h))
        
        vbox.Add(textBox, 1, wxEXPAND|wxALL, 10)
        
        buttons = wxBoxSizer(wxHORIZONTAL)
        buttons.Add(wxButton(self, wxID_OK, _("Close")), 0, wxALL, 4)
        vbox.Add(buttons, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 10)
        
        EVT_BUTTON(self, wxID_OK, self.OnClose)
        
        self.SetAutoLayout(True)
        self.SetSizer(vbox)
        vbox.Fit(self)
        vbox.SetSizeHints(self)


    def calcText(self, layer):
        """
        Generate the text to be displayed in the information window

        It will use several nodes returned by the GetCapabilities
        request, such as the title, the abstract, fees and access
        constraints, if they are documented.
        """

        text = ''

        foo = layer.capabilities.getTitle()
        if foo != "":
            text += foo.encode('latin1') + "\n\n"

        foo = layer.capabilities.getAbstract()
        if foo != "":
            text += foo + "\n\n"

        foo = layer.capabilities.getFees()
        if foo != "":
            text += _("Fees:") + "\n\n" + foo + "\n\n"

        foo = layer.capabilities.getAccessConstraints()
        if foo != "":
            text += _("Acces Constraints:") + "\n\n" + foo + "\n\n"

        text += "URL: " + layer.url

        return text
