# Copyright (C) 2004 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de> (2004)
# Jan-Oliver Wagner <jan@intevation.de> (2004)
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

# import the actual modules
from os import environ
try:
    dummy = environ["DISPLAY"]
    import svgsaver
    import maplegend
except:
    pass # we don't have a DISPLAY, so don't import the modules
         # (we probably are in test-mode)
         # Not sure whether this is the best method to avoid problems
         # in the global test routine.

# perform the registration of the extension
from Thuban import _
from Thuban.UI.extensionregistry import ExtensionDesc, ext_registry

ext_registry.add(ExtensionDesc(
    name = 'SVG Export',
    version = '1.0.0cvs',
    authors= [ 'Markus Rechtien', 'Bernhard Reiter' ],
    copyright = '2004 Intevation GmbH',
    desc = _("Export the current map and legend in Thuban-map-SVG format.")))
