# Copyright (C) 2004 by Intevation GmbH
# Authors:
# Nina Hueffmeyer <nhueffme@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with the software for details.

__version__ = "$Revision: 1.3 $"
# $Source: /thubanrepository/thuban/Extensions/ogr/__init__.py,v $
# $Id: __init__.py,v 1.3 2005/01/31 09:18:27 nhueffme Exp $

# import the actual modules
from os import environ
try:
    dummy = environ["DISPLAY"]
    import OGR
    import maplegend
except:
    pass # we don't have a DISPLAY, so don't import the modules
         # (we probably are in test-mode)
         # Not sure whether this is the best method to avoid problems
         # in the global test routine.

# perform the registration of the extension
from Thuban import _
from Thuban.UI.extensionregistry import ExtensionDesc, ext_registry

ext_registry.add(ExtensionDesc(
    name = 'OGRstart',
    version = '0.9.0',
    authors= [ 'Nina Hueffmeyer' ],
    copyright = '2004 Intevation GmbH',
    desc = _("Open a file supported by ogr.")))
