# Copyright (c) 2001, 2002, 2003 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
# Frank Koormann <frank.koormann@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.14 $"

from wxPython.wx import *
from wxPython.grid import *

from Thuban import _

from dialogs import NonModalDialog
from controls import RecordListCtrl, RecordGridCtrl
from messages import SHAPES_SELECTED

class IdentifyListCtrl(RecordListCtrl):

    def selected_shape(self, layer, shape):
        if layer is not None:
            table = layer.ShapeStore().Table()
        else:
            table = None
        self.fill_list(table, shape)

class IdentifyGridCtrl(RecordGridCtrl):

    def selected_shape(self, layer, shape):
        if layer is not None:
            table = layer.ShapeStore().Table()
        else:
            table = None
        self.SetTableRecord(table, shape)

class IdentifyView(NonModalDialog):

    def __init__(self, parent, name):
        NonModalDialog.__init__(self, parent, name, _("Identify Shape"))
        parent.Subscribe(SHAPES_SELECTED, self.selected_shape)

        top_box = wxBoxSizer(wxVERTICAL)
        #self.list = IdentifyGridCtrl(panel)
        self.list = IdentifyListCtrl(self, -1)
        self.list.SetSize(wxSize(305,200))
        top_box.Add(self.list, 1, wxEXPAND|wxALL, 4)

        box = wxBoxSizer(wxHORIZONTAL)
        box.Add(wxButton(self, wxID_CLOSE, _("Close")), 0, wxALL, 4) 
        top_box.Add(box, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 4)

        EVT_BUTTON(self, wxID_CLOSE, self.OnClose)

        self.SetAutoLayout(True)
        self.SetSizer(top_box)
        top_box.Fit(self)
        top_box.SetSizeHints(self)

        # Make sure to reflect the current selection.
        self.selected_shape(parent.SelectedLayer(), parent.SelectedShapes())

    def OnClose(self, event):
        self.parent.Unsubscribe(SHAPES_SELECTED, self.selected_shape)
        NonModalDialog.OnClose(self, event)

    def selected_shape(self, layer, shapes):
        """Subscribed to the SHAPES_SELECTED messages.

        If exatly one shape is selected, pass that shape id to the
        list's selected_shape method. Otherwise pass None as the shape
        id.
        """
        if len(shapes) == 1:
            shape = shapes[0]
        else:
            shape = None
        self.list.selected_shape(layer, shape)
