# Copyright (c) 2001, 2003 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
# Frank Koormann <frank.koormann@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""Base classes for dialogs"""

__version__ = "$Revision: 1.7 $"

from wxPython.wx import *

class ThubanFrame(wxFrame):

    def __init__(self, parent, name, title):
        wxFrame.__init__(self, parent, -1, title,
            style = wxDEFAULT_FRAME_STYLE )
        self.parent = parent
        self.name = name
        EVT_CLOSE(self, self.OnClose)

    def OnClose(self, event):
        if self.parent.dialogs.has_key(self.name):
            self.parent.remove_dialog(self.name)
        self.Destroy()

class NonModalDialog(wxDialog):
    def __init__(self, parent, name, title):
        wxDialog.__init__(self, parent, -1, title, 
            style = wxDEFAULT_DIALOG_STYLE 
                  | wxSYSTEM_MENU
                  | wxMINIMIZE_BOX 
                  | wxMAXIMIZE_BOX 
                  | wxRESIZE_BORDER
            )
        self.parent = parent
        self.name = name
        EVT_CLOSE(self, self.OnClose)

    def OnClose(self, event):
        if self.parent.dialogs.has_key(self.name):
            self.parent.remove_dialog(self.name)
        self.Destroy()

class NonModalNonParentDialog(wxDialog):
    def __init__(self, parent, name, title):
        wxDialog.__init__(self, None, -1, title, 
            style = wxDEFAULT_DIALOG_STYLE 
                  | wxSYSTEM_MENU
                  | wxMINIMIZE_BOX 
                  | wxMAXIMIZE_BOX 
                  | wxRESIZE_BORDER
                  | wxDIALOG_NO_PARENT
            )
        self.parent = parent
        self.name = name
        EVT_CLOSE(self, self.OnClose)

    def OnClose(self, event):
        if self.parent.dialogs.has_key(self.name):
            self.parent.remove_dialog(self.name)
        self.Destroy()
