# Copyright (c) 2001, 2002, 2003 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""The About Box"""

__version__ = "$Revision: 1.8 $"
# $Source: /thubanrepository/thuban/Thuban/UI/about.py,v $
# $Id: about.py,v 1.8 2003/08/22 16:01:14 bh Exp $

from wxPython.wx import *

from Thuban import _
from Thuban.version import versions

class About(wxDialog):

    def __init__(self, parent):
        wxDialog.__init__(self, parent, -1, _("About Thuban"),
            style = wxDEFAULT_DIALOG_STYLE
                  | wxSYSTEM_MENU
                  | wxMINIMIZE_BOX
                  | wxMAXIMIZE_BOX
                  | wxRESIZE_BORDER,
            size = (400, 250))

        lead_developer = 'Bernhard Herzog'
        developers = [ 'Jonathan Coles', 'Frank Koormann',
                       'Martin Mller', 'Jan-Oliver Wagner' ]
        translators = [ ( _('French'), 'Daniel Calvelo Aros' ),
                        ( _('German'), 'Bjrn Broscheit'),
                        ( _('Italian'), 'Maurizio Napolitano'),
                        ( _('Russian'), 'Alex Shevlakov'),
                        ( _('Spanish'), 'Daniel Calvelo Aros') ]
        other_contributors = [ 'Jonathan Byron', 'Silke Reimer',
                               'Bernhard Reiter' ]
        dyn_modules = [ ('wxPython', versions['wxPython']),
                        ('Python',   versions['python']),
                        ('PySQLite', versions['pysqlite']),
                        ('SQLite',  versions['sqlite']),
                        ('GDAL', versions.get('gdal', _('- not available'))),
                        ('psycopg', versions.get('psycopg',
                                                 _('- not available')))]
        direct_modules = [ \
                ('GTK',      versions.get('gtk', _('- not available'))),
                ('proj',     versions['proj']) ]

        text = 'Thuban %s\n\n' % versions['thuban-long']

        text += _('Currently using:\n')

        for name, version in dyn_modules:
            text+= '\t%s %s\n' % (name, version)
        text += '\n'

        text += _('Compiled for:\n')

        for name, version in direct_modules:
            text+= '\t%s %s\n' % (name, version)
        text += '\n'

        text += _('Lead Developer:\n')
        text += '\t%s\n\n' % lead_developer

        text += _('Developers:\n')
        for name in developers:
            text += '\t%s\n' % name
        text += '\n'

        text += _('Translators:\n')
        for lang, name in translators:
            text += '\t%s: %s\n' % (lang, name)
        text += '\n'

        text += _('Other Contributors:\n')
        for name in other_contributors:
            text += '\t%s\n' % name
        text += '\n'

        text += \
            _("Questions and comments can be sent to the following addresses:\n"
            "\tThuban developers:\n\t\t<thuban@intevation.de>\n"
            "\tThuban mailing list:\n\t\t<thuban-list@intevation.de>")

        self.text = text

        text_title = wxStaticText(self, -1, 
            _("Thuban is a program for exploring geographic data.\n\n") +
            "Copyright 2001-2003 Intevation GmbH.\n" +
            _("Thuban is licensed under the GNU GPL"),
                                  style=wxST_NO_AUTORESIZE|wxALIGN_CENTRE)

        textBox = wxTextCtrl(self, -1, text, 
            style=wxTE_READONLY|wxTE_MULTILINE|wxTE_LINEWRAP)
        w, h = (300, 150)
        textBox.SetSizeHints(w, h)
        textBox.SetSize((w, h))

        button_close = wxButton(self, wxID_CANCEL, _("Close"))
        button_close.SetDefault()

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(text_title, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 10)
        sizer.Add(textBox, 1, wxALL|wxEXPAND, 10)
        sizer.Add(button_close, 0, wxALL|wxALIGN_RIGHT, 10)

        self.SetAutoLayout(True)
        self.SetSizer(sizer)
        sizer.Fit(self)
        sizer.SetSizeHints(self)
        self.Layout()

        EVT_BUTTON(self, wxID_CANCEL, self.OnCancel)

    def OnCancel(self, event):
        self.EndModal(wxID_CANCEL)


