# Copyright (c) 2002 by Intevation GmbH
# Authors:
# Frank Koormann <frank.koormann@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Test the Thuban export calculations
"""

__version__ = "$Revision: 1.1 $"
# $Source: /home/thuban/jail/thubanrepository/thuban/test/test_export.py,v $
# $Id: test_export.py,v 1.1 2003/05/16 16:25:58 frank Exp $

from Thuban import _

import unittest
import os

import support
support.initthuban()

from Thuban.UI.view import OutputTransform

class TestScalebar(unittest.TestCase, support.FloatComparisonMixin):

    """Test cases for the Thuban export calculations
    """

    def test_OutputTransform(self):
        """Test MapCanvas.OutputTransform()."""
        
        scale, offset, mapregion = OutputTransform(1.0, (0,0),(200, 100), (200,100))
        self.assertFloatEqual(0.3, scale)
        self.assertFloatSeqEqual((0.0, 0.0), offset)
        self.assertFloatSeqEqual((20.0, 20.0, 80.0, 80.0), mapregion)

        scale, offset, mapregion = OutputTransform(1.0, (0,0),(200, 100), (100,200))
        self.assertFloatEqual(0.16, scale)
        self.assertFloatSeqEqual((0.0, 0.0), offset)
        self.assertFloatSeqEqual((20.0, 20.0, 52.0, 52.0), mapregion)

        scale, offset, mapregion = OutputTransform(1.0, (5,5),(200, 100), (100,100))
        self.assertFloatEqual(0.16, scale)
        self.assertFloatSeqEqual((0.8, 0.8), offset)
        self.assertFloatSeqEqual((20.0, 20.0, 52.0, 52.0), mapregion)

        scale, offset, mapregion = OutputTransform(1.0, (0,0),(200, 100), (200,200))
        self.assertFloatEqual(0.52, scale)
        self.assertFloatSeqEqual((0.0, 0.0), offset)
        self.assertFloatSeqEqual((20, 20, 124.0, 124.0), mapregion)


if __name__ == "__main__":
    unittest.main()
