# Copyright (c) 2002, 2003 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Main entry point for the Thuban test suite.

Just run this file as a python script to execute all tests
"""

__version__ = "$Revision: 1.5 $"
# $Source: /home/thuban/jail/thubanrepository/thuban/test/runtests.py,v $
# $Id: runtests.py,v 1.5 2003/06/20 16:10:22 bh Exp $

import os, sys
import warnings
import unittest

import support
support.initthuban()
import Thuban.Lib.connector

def main():
    """Run all the tests in the Thuban test suite"""

    # Turn Thuban's deprecation warnings into errors so they're cought
    # by the tests
    #
    # Maintenance: Keep a warning filter until the backwards
    # compatibility code is removed at which time using the old
    # interfaces should lead to other errors anyway.

    # The layer attributes table, shapetable, shapefile and filename are
    # deprecated.
    warnings.filterwarnings("error", "The Layer attribute.*is deprecated",
                            DeprecationWarning)

    # Usage of the old table interface. This old interface is still used
    # by the test_table.py module which calls filterwarnings too to
    # ignore the warnings issued by its own intended use of the old
    # interface.
    warnings.filterwarnings("error", ".*old table interface.*",
                            DeprecationWarning)


    # All Python files starting with test in the current directory
    # contain test cases.
    # FIXME: It should be possible to run runtests.py even when not in
    # the test directory
    files = os.listdir(os.curdir)
    names = []
    for file in files:
        if file[:4] == "test" and file[-3:] == ".py":
            names.append(file[:-3])

    suite = unittest.defaultTestLoader.loadTestsFromNames(names)
    runner = unittest.TextTestRunner(verbosity = 2)
    result = runner.run(suite)

    support.print_additional_summary()

    sys.exit(not result.wasSuccessful())


if __name__ == "__main__":
    main()
