# Copyright (c) 2003 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

import os
import Thuban

from wxPython.wx import wxBITMAP_TYPE_XPM, wxBITMAP_TYPE_ANY, wxBitmap, wxImage


bitmapdir = os.path.join(Thuban.__path__[0], os.pardir, "Resources", "Bitmaps")
bitmap_extensions = {wxBITMAP_TYPE_XPM: ".xpm",
                     wxBITMAP_TYPE_ANY: ""}
                     
def GetBitmapResource(file, type):
    filename = os.path.join(bitmapdir, file) + bitmap_extensions[type]
    return wxBitmap(filename, type)

def GetImageResource(file, type):
    filename = os.path.join(bitmapdir, file) + bitmap_extensions[type]
    return wxImage(filename, type)

