#! /usr/bin/python
# Copyright (C) 2001, 2002 by Intevation GmbH
# Authors:
# Jan-Oliver Wagner <jan@intevation.de>
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
The main entry point for the Thuban GUI. 
"""

__version__ = "$Revision: 1.9 $"

import sys

from application import ThubanApplication
import Thuban.version

def main():
    """Instantiate the application object and run the application"""

    if verify_versions():
        app = ThubanApplication(0)
        if len(sys.argv) > 1:
            app.OpenSession(sys.argv[1])
        app.MainLoop()

def verify_versions():
    """Check some library versions.

    Print a message containing any libraries which are wrong.
    Return True if everything is OK, otherwise False.
    """
    
    errors = Thuban.version.verify_versions()

    if len(errors) > 0:
        msg = " The following version errors were detected:"

        for e in errors:
            msg += "\n     " + e

#       if use_msg_box:
#           # XXX: use a message box to display the errors
#           pass

        print "\n*******************************************************"
        print msg
        print "*******************************************************\n"

        return False

    return True
