# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Classes implementing the global interaction and selection semantics
"""

__version__ = "$Revision: 1.2 $"

from Thuban.Lib.connector import Publisher

from Thuban.Model.table import Table
from Thuban.Model.layer import Layer

from messages import SELECTED_MAP, SELECTED_LAYER, SELECTED_SHAPE


class Interactor(Publisher):

    def __init__(self, session):
        self.SetSession(session)

    def SetSession(self, session):
        self.session = session
        self.selected_map = None
        self.selected_layer = None
        self.selected_table = None
        self.selected_shape = None
        self.issue(SELECTED_MAP, self.selected_map)
        self.issue(SELECTED_LAYER, self.selected_layer)
        self.issue(SELECTED_SHAPE, self.selected_layer, self.selected_shape)

    def SelectedLayer(self):
        return self.selected_layer

    def HasSelectedLayer(self):
        return self.selected_layer is not None

    def SelectMap(self, map):
        if self.selected_map is not map:
            self.selected_map = map
            self.selected_layer = None
            self.selected_shape = None
            self.issue(SELECTED_MAP, self.selected_map)
            self.issue(SELECTED_LAYER, self.selected_layer)
            self.issue(SELECTED_SHAPE,
                       self.selected_layer, self.selected_shape)

    def SelectLayer(self, layer):
        if self.selected_layer is not layer:
            self.selected_layer = layer
            self.selected_shape = None
            self.issue(SELECTED_LAYER, self.selected_layer)
            self.issue(SELECTED_SHAPE,
                       self.selected_layer, self.selected_shape)

    def SelectShape(self, parent, shape):
        # parent may be table or layer
        doselect = 0
        if isinstance(parent, Table):
            if self.selected_layer is not None \
               and self.selected_layer.table is parent:
                doselect = 1
        elif isinstance(parent, Layer):
            doselect = 1
        if doselect and self.selected_shape != shape:
            self.selected_shape = shape
            self.issue(SELECTED_SHAPE,
                       self.selected_layer, self.selected_shape)
            return 1
        return 0

    def SelectLayerAndShape(self, layer, shape):
        if self.selected_layer is not layer:
            self.selected_layer = layer
            issue_layer = 1
            self.selected_shape = shape
            issue_shape = 1
        else:
            issue_layer = 0
            if self.selected_shape != shape:
                self.selected_shape = shape
                issue_shape = 1
            else:
                issue_shape = 0

        if issue_layer:
            self.issue(SELECTED_LAYER, self.selected_layer)
        if issue_shape:
            self.issue(SELECTED_SHAPE,
                       self.selected_layer, self.selected_shape)

