# Copyright (c) 2001, 2002, 2003 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

from wxPython.wx import *

from Thuban import _
from Thuban.version import versions

class About(wxDialog):

    def __init__(self, parent):
        wxDialog.__init__(self, parent, -1, _("About Thuban"),
            style = wxDEFAULT_DIALOG_STYLE
                  | wxSYSTEM_MENU
                  | wxMINIMIZE_BOX
                  | wxMAXIMIZE_BOX
                  | wxRESIZE_BORDER,
            size = (400, 250))

        text = _(#"Build Date: %s\n"
            "%s\n\n"
            "Currently using:\n"
            "\t%s\n"
            "\t%s\n"
            "\t%s\n"
            "\t%s\n"
            "\t%s\n\n"
            "Compiled against:\n"
            "\t%s\n"
            "\t%s\n\n"
            "Lead Developer:\n"
            "\tBernhard Herzog\n\n"
            "Developers:\n"
            "\tJonathan Coles\n"
            "\tFrank Koormann\n"
            "\tBernhard Reiter\n"
            "\tJan-Oliver Wagner\n\n"
            "Contributors:\n"
            "\tJonathan Byron\n"
            "\tMartin Mller\n\n"
            "Questions and comments can be sent to the following addresses:\n"
            "\tThuban developers:\n\t\t<thuban@intevation.de>\n"
            "\tThuban mailing list:\n\t\t<thuban-list@intevation.de>"
            % ("Thuban %s"      % versions['thuban-long'],
               "wxPython %s"    % versions['wxPython'],
               "Python %s"      % versions['python'],
               "PySQLite %s"    % versions['pysqlite'],
               "SQLite %s"      % versions['sqlite'],
               "GDAL %s"        % versions.get('gdal', "- not available"),
               "GTK %s"         % versions.get('gtk', "- not available"),
               "proj %s"        % versions['proj']))

        self.text = text

        text_title = wxStaticText(self, -1, 
            "Thuban is a program for exploring geographic data.\n\n"
            "Copyright 2001-2003 Intevation GmbH.\n"
            "Thuban is licensed under the GNU GPL",
                                  style=wxST_NO_AUTORESIZE|wxALIGN_CENTRE)

        textBox = wxTextCtrl(self, -1, text, 
            style=wxTE_READONLY|wxTE_MULTILINE|wxTE_LINEWRAP)
        w, h = (300, 150)
        textBox.SetSizeHints(w, h)
        textBox.SetSize((w, h))

        button_close = wxButton(self, wxID_CANCEL, _("Close"))
        button_close.SetDefault()

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(text_title, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 10)
        sizer.Add(textBox, 1, wxALL|wxEXPAND, 10)
        sizer.Add(button_close, 0, wxALL|wxALIGN_RIGHT, 10)

        self.SetAutoLayout(True)
        self.SetSizer(sizer)
        sizer.Fit(self)
        sizer.SetSizeHints(self)
        self.Layout()

        EVT_BUTTON(self, wxID_CANCEL, self.OnCancel)

    def OnCancel(self, event):
        self.EndModal(wxID_CANCEL)


