# Copyright (c) 2003 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

import os
import Thuban

from wxPython.wx import wxBITMAP_TYPE_XPM, wxBitmap


bitmapdir = os.path.join(Thuban.__path__[0], os.pardir, "Resources", "Bitmaps")
EXT_XPM  = ".xpm"
EXT_NONE = ""


def GetBitmapResource(file, type):
    if type == wxBITMAP_TYPE_XPM:
        ext = EXT_XPM
    else:
        ext = EXT_NONE

    filename = os.path.join(bitmapdir, file) + ext
    return wxBitmap(filename, type)

