#! /usr/bin/python
# Copyright (C) 2001, 2002 by Intevation GmbH
# Authors:
# Jan-Oliver Wagner <jan@intevation.de>
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
The main entry point for the Thuban GUI. 
"""

__version__ = "$Revision: 1.8 $"

import sys

from application import ThubanApplication

from wxPython.wx import wxMAJOR_VERSION, wxMINOR_VERSION, wxRELEASE_NUMBER,\
                        wxPlatform
import wxproj


def main():
    """Instantiate the application object and run the application"""

    if verify_versions():
        app = ThubanApplication(0)
        if len(sys.argv) > 1:
            app.OpenSession(sys.argv[1])
        app.MainLoop()


def wxCHECK_VERSION(major,minor,release): \
    return (wxMAJOR_VERSION > (major) or \
        (wxMAJOR_VERSION == (major) \
            and wxMINOR_VERSION > (minor)) or \
        (wxMAJOR_VERSION == (major) \
            and wxMINOR_VERSION == (minor) \
            and wxRELEASE_NUMBER >= (release)))

def verify_versions():
    """Check some library versions.

    Print a message containing any libraries which are wrong.
    Return True if everything is OK, otherwise False.

    Specifically, check the following libraries:

        wxPython >= v2.4.0
        Python >= v2.2.1
        proj >= v4.4.5
        gtk > v1.2.0
    """
    
    errors = []

    if not wxCHECK_VERSION(2, 4, 0):
        errors.append("wxPython < 2.4.0")

    if sys.hexversion < 0x0202010f:
        errors.append("Python < 2.2.1")

    #
    # This only tells someone that they COMPILED thuban with the wrong
    # version of proj. If they are running prebuilt binaries 
    # check_version should always return true.
    #
    if not wxproj.check_version(4, 4, 5):
        errors.append("proj < 4.4.5")

    if wxPlatform == "__WXGTK__":
        if not wxproj.check_version_gtk(1, 2, 0):
            errors.append("gtk < 1.2")

    if len(errors) > 0:
        msg = " The following version errors were detected:"

        for e in errors:
            msg += "\n     " + e

#       if use_msg_box:
#           # XXX: use a message box to display the errors
#           pass

        print "\n*******************************************************"
        print msg
        print "*******************************************************\n"

        return False

    return True
