# Copyright (c) 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Test the Thuban-specific Projection class
"""

__version__ = "$Revision: 1.1 $"
# $Source: /thubanrepository/thuban/test/test_proj.py,v $
# $Id: test_proj.py,v 1.1 2002/09/20 15:47:07 bh Exp $

import unittest

import support
support.initthuban()

from Thuban.Model.proj import Projection


class TestProjection(unittest.TestCase, support.FloatComparisonMixin):

    """Test cases for the Thuban-specific Projection class
    """

    def test(self):
        """Test Projection"""
        proj = Projection(["zone=26", "proj=utm", "ellps=clrk66"])
        self.assertEquals(proj.params, ["zone=26", "proj=utm", "ellps=clrk66"])

        # It's not clear whether this value is really the correct one
        # but a test failure here probably still means a bug somewhere
        self.assertFloatSeqEqual(proj.Forward(0, 0),
                                 [3623101.8103431347, 0.0],
                                 epsilon = 1e-5)
        self.assertFloatSeqEqual(proj.Inverse(3623101.8103431347, 0.0),
                                 [-0.00065775699878736467, 0])

        self.assertFloatSeqEqual(proj.ForwardBBox((0, 0, 2, 2)),
                                 (3620891.3077618643, 0.0,
                                  3875381.8535437919, 252962.10480170773),
                                 epsilon = 1e-5)



if __name__ == "__main__":
    unittest.main()
