# Copyright (c) 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Test the Color class
"""

__version__ = "$Revision: 1.1 $"
# $Source: /thubanrepository/thuban/test/test_color.py,v $
# $Id: test_color.py,v 1.1 2002/09/20 14:07:26 bh Exp $

import unittest

import support
support.initthuban()

from Thuban.Model.color import Color


class TestColor(unittest.TestCase):

    def test(self):
        """Test Color"""
        # The color objects are very simple. We just have to test
        # whether instantiating one assigns the colors to the right
        # instance variables and whether the correct hex string is
        # produced
        color = Color(0, 0.5, 1.0)
        self.assertEquals(color.red, 0.0)
        self.assertEquals(color.green, 0.5)
        self.assertEquals(color.blue, 1.0)
        self.assertEquals(color.hex().lower(), "#007fff")

if __name__ == "__main__":
    unittest.main()
