# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

def Str2Num(num):
    """Converts a string into the "most appropriate" form. 

    This function attempts to return the converted number in the 
    smallest form such that int < long < float.
    """

    f = float(num)
                                                                            
    #
    # if there's an exception after this point it is because
    # the number is a float
    #
    try:
        l = long(f)
        i = int(f)
        if l == f:
            if i == l:
                # we didn't try to stuff a long into an int
                return i
            else:
                return l
        else:
            return f
    except ValueError:
        return f

