# Copyright (c) 2001, 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.7 $"

from wxPython.wx import *
from wxPython.grid import *

from Thuban import _

import view
from dialogs import NonModalDialog
from controls import RecordListCtrl, RecordGridCtrl
from messages import SELECTED_SHAPE

class IdentifyListCtrl(RecordListCtrl):

    def selected_shape(self, layer, shape):
        if layer is not None:
            table = layer.shapetable
        else:
            table = None
        self.fill_list(table, shape)

class IdentifyGridCtrl(RecordGridCtrl):

    def selected_shape(self, layer, shape):
        if layer is not None:
            table = layer.shapetable
        else:
            table = None
        self.SetTableRecord(table, shape)

class IdentifyView(NonModalDialog):

    def __init__(self, parent, interactor, name):
        NonModalDialog.__init__(self, parent, interactor, name,
                                _("Identify Shape"))
        self.interactor.Subscribe(SELECTED_SHAPE, self.selected_shape)
        
        panel = wxPanel(self, -1, style = wxWANTS_CHARS)
        #self.list = IdentifyListCtrl(panel, -1)
        self.list = IdentifyGridCtrl(panel)

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(self.list, 1, wx.wxEXPAND| wx.wxALL, 0)
        
        self.SetSize(wxSize(300,200))
        panel.SetAutoLayout(true)
        panel.SetSizer(sizer)
        sizer.Fit(panel)

    def OnClose(self, event):
        self.interactor.Unsubscribe(SELECTED_SHAPE, self.selected_shape)
        NonModalDialog.OnClose(self, event)

    def selected_shape(self, layer, shape):
        self.list.selected_shape(layer, shape)
