# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

from Thuban.Model.color import Color
from wxPython.wx import wxColour

def Color2wxColour(color):
    assert(color is not None)
    assert(isinstance(color, Color))
    return wxColour(color.red   * 255,
                    color.green * 255,
                    color.blue  * 255)

def wxColour2Color(colour):
    assert(colour is not None)
    # this doesn't work because colour is really a wxColourPtr!
    #assert(isinstance(colour, wxColour))
    return Color(colour.Red()   / 255.0,
                 colour.Green() / 255.0,
                 colour.Blue()  / 255.0)

