# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.1 $"

import Projection
BaseProjection = Projection.Projection
del Projection

class Projection(BaseProjection):

    """A proj4 projection object that remembers the parameters"""

    def __init__(self, params):
        BaseProjection.__init__(self, params)
        self.params = params

    def ForwardBBox(self, bbox):
        """Return the bounding box of the corners of the bounding box bbox
        """
        # This is not really the correct way to determine the bbox of a
        # projected shape, but for now it works well enough
        llx, lly, urx, ury = bbox
        xs = []; ys = []
        x, y = self.Forward(llx, lly)
        xs.append(x); ys.append(y)
        x, y = self.Forward(llx, ury)
        xs.append(x); ys.append(y)
        x, y = self.Forward(urx, ury)
        xs.append(x); ys.append(y)
        x, y = self.Forward(urx, lly)
        xs.append(x); ys.append(y)
        return min(xs), min(ys), max(xs), max(ys)
