# Copyright (c) 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Main entry point for the Thuban test suite.

Just run this file as a python script to execute all tests
"""


import os, sys
import unittest

import support
support.initthuban()
import Thuban.Lib.connector

def main():
    """Run all the tests in the Thuban test suite"""

    Thuban.Lib.connector._the_connector.print_connections()

    files = os.listdir(os.curdir)
    names = []
    for file in files:
        if file[:4] == "test" and file[-3:] == ".py":
            names.append(file[:-3])

    suite = unittest.defaultTestLoader.loadTestsFromNames(names)
    runner = unittest.TextTestRunner(verbosity = 2)
    result = runner.run(suite)

    Thuban.Lib.connector._the_connector.print_connections()

    sys.exit(not result.wasSuccessful())


if __name__ == "__main__":
    main()
