# Copyright (c) 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2)
# Read the file COPYING for details.

"""
Test the Python DBF interface
"""

__version__ = "$Revision: $"
# $Source: $
# $Id: $

import os
import unittest

import dbflib


class WriteDBFTest(unittest.TestCase):

    filename = "test_dbf_write.dbf"
    
    def test(self):
        # Create the DBF file.
        dbf = dbflib.create(self.filename)
        dbf.add_field("NAME", dbflib.FTString, 20, 0)
        dbf.add_field("INT", dbflib.FTInteger, 10, 0)
        dbf.add_field("FLOAT", dbflib.FTDouble, 10, 4)

        
        


def make_dbf(file):
    # create a new sbf file file and add three fields.

def add_dbf_records(file):
    # add some records to file
    dbf = dbflib.open(file, "r+b")
    # Records can be added as a dictionary...
    dbf.write_record(0, {'NAME': "Weatherwax", "INT":1, "FLOAT":3.1415926535})
    # ... or as a sequence
    dbf.write_record(1, ("Ogg", 2, -1000.1234))

def list_dbf(file):
    # print the contents of a dbf file to stdout
    dbf = dbflib.DBFFile(file)
    print "%d records, %d fields" % (dbf.record_count(), dbf.field_count())
    format = ""
    for i in range(dbf.field_count()):
        type, name, len, decc = dbf.field_info(i)
        if type == 0:
            format = format + " %%(%s)%ds" % (name, len)
        elif type == 1:
            format = format + " %%(%s)%dd" % (name, len)
        elif type == 2:
            format = format + " %%(%s)%dg" % (name, len)
    print format
    for i in range(dbf.record_count()):
        print format % dbf.read_record(i)
