# Copyright (c) 2001, 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.


# Work-around for a locale related bug in wxPython (which is fixed in
# 2.3)
#
# we can probably safely assume that any program that imports the
# Thuban.UI module will use wxPython, so we put the fix here.
#
# Import wxPython.wx here to get the side effects of the wxPython
# import, especially setting the locale to the user's defaults throught
# GTK. We then set the locale again to the user's defaults, but this
# time we're going through the standard python locale module, so all the
# magic necessary to make python work properly is done. Without this,
# something harmless like float("1.2") may fail when run under a non-C
# locale like de_DE
import wxPython.wx
del wxPython
try:
    import locale
    locale.setlocale(locale.LC_ALL, "")
    del locale
except ImportError:
    # the locale module may not be available on some systems
    pass

