
import os
from distutils.core import setup, Extension

# try to determine the directory where the shapelib source files are.
# There are currently two supported situations.
#
# 1. "Standalone" build: the parent directory is the shapelib source
#    directory
# 2. Built in the Thuban source tree where it's ../shapelib/ relative to
#    the directory containing this setup.py
if os.path.exists(os.path.join(os.pardir, "shpeopen.c")):
    shp_dir = os.pardir
elif os.path.exists(os.path.join(os.pardir, "shapelib"))::
    shp_dir = os.path.join(os.pardir, "shapelib")

extensions = [Extension("shapelibc",
                        ["shapelib_wrap.c",
                         os.path.join(shp_dir, "shpopen.c")],
                        include_dirs = [shp_dir]),
              Extension("dbflibc",
                        ["dbflib_wrap.c",
                         os.path.join(shp_dir, "dbfopen.c")],
                        include_dirs = [shp_dir])]

setup(name = "pyshapelib",
      version = "0.3",
      description = "Python bindings for shapelib",
      author = "Bernhard Herzog",
      author_email = "bh@intevation.de",
      url = "ftp:intevation.de/users/bh",
      py_modules = ["shapelib", "dbflib"],
      ext_modules = extensions)

