#! /usr/bin/python
# Copyright (C) 2001 by Intevation GmbH
# Authors:
# Jan-Oliver Wagner <jan@intevation.de>
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
The main entry point for the Thuban GUI. 
"""

__version__ = "$Revision: 1.3 $"

import sys

# import wxPython.wx here to get the side effects of the wxPython
# import, especially setting the locale to the user's defaults throught
# GTK. We then set the locale again to the user's defaults, but this
# time we're going through the standard python locale module, so all the
# magic necessary to make python work properly is done. Without this,
# something harmless like float("1.2") may fail when run under a non-C
# locale like de_DE
import wxPython.wx
try:
    import locale
    locale.setlocale(locale.LC_ALL, "")
except ImportError:
    # the locale module may not be available on some systems
    pass

from application import ThubanApplication

def main():
    """Instantiate the application object and run the application"""
    global app
    app = ThubanApplication(0)
    if len(sys.argv) > 1:
        app.OpenSession(sys.argv[1])
    app.top.ShowSessionTree()
    app.MainLoop()
