# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""Base classes for dialogs"""

__version__ = "$Revision: 1.1 $"

from wxPython.wx import wxFrame, EVT_CLOSE

class NonModalDialog(wxFrame):

    def __init__(self, parent, interactor, name, title):
        wxFrame.__init__(self, parent, -1, title)
        self.parent = parent
        self.interactor = interactor
        self.name = name
        EVT_CLOSE(self, self.OnClose)

    def OnClose(self, event):
        self.parent.remove_dialog(self.name)
        self.Destroy()
