# Copyright (C) 2001 by Intevation GmbH
# Authors:
# Jan-Oliver Wagner <jan@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Thuban's application object.
"""

__version__ = "$Revision: 1.3 $"

from wxPython.wx import *

from Thuban.Lib.connector import Publisher

from Thuban.Model.session import create_empty_session
from Thuban.Model.save import save_session
from Thuban.Model.load import load_session

import view
import tree
from interactor import Interactor
from mainwindow import MainWindow

from messages import SESSION_CHANGED



class ThubanApplication(wxApp, Publisher):

    """
    Thuban's application class.

    All wxWindows programs have to have an instance of an application
    class derived from wxApp. In Thuban the application class holds
    references to the main window, the session and the interactor.
    """

    def OnInit(self):
        self.interactor = Interactor(None)
        top = MainWindow(NULL, -1, self.interactor)
        top.Show(true)
        self.top = top
        self.SetTopWindow(top)
        self.session = None
        self.create_session()
        return true

    def SetSession(self, session):
        oldsession = self.session
        self.session = session
        self.issue(SESSION_CHANGED)
        self.interactor.SetSession(session)
        self.set_map()
        if oldsession is not None:
            oldsession.Destroy()

    def create_session(self):
        # Create a simple default session
        self.SetSession(create_empty_session())

    def OpenSession(self, filename):
        session = load_session(filename)
        session.SetFilename(filename)
        session.UnsetModified()
        self.SetSession(session)

    def SaveSession(self):
        save_session(self.session, self.session.filename)

    def set_map(self):
        if self.session.HasMaps():
            self.top.SetMap(self.session.Maps()[0])
        else:
            self.top.SetMap(None)
