# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Classes for handling tables of data.
"""

__version__ = "$Revision: 1.1 $"

import dbflib

# the field types supported by a Table instance.
FIELDTYPE_INT = "int"
FIELDTYPE_STRING = "string"
FIELDTYPE_DOUBLE = "double"


# map the dbflib constants for the field types to our constants
dbflib_fieldtypes = {dbflib.FTString: FIELDTYPE_STRING,
                     dbflib.FTInteger: FIELDTYPE_INT,
                     dbflib.FTDouble: FIELDTYPE_DOUBLE}

class Table:

    """
    Represent a table of data.

    Currently this is basically just a wrapper around dbflib.
    """

    def __init__(self, filename):
        self.filename = filename
        self.dbf = dbflib.DBFFile(filename)

    def record_count(self):
        """Return the number of records"""
        return self.dbf.record_count()

    def field_count(self):
        """Return the number of fields in a record"""
        return self.dbf.field_count()

    def field_info(self, field):
        """Return a tuple (type, name, width, prec) for the field no. field

        type is the data type of the field, name the name, width the
        field width in characters and prec the decimal precision.
        """
        type, name, width, prec = self.dbf.field_info(field)
        type = dbflib_fieldtypes[type]
        return type, name, width, prec

    def read_record(self, record):
        """Return the record no. record as a dict mapping field names to values
        """
        return self.dbf.read_record(record)

    
