# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.1 $"

class Color:

    """An RGB color. RGB values are floats in the range 0.0 .. 1.0

    Color objects should be treated as immutable
    """

    def __init__(self, red, green, blue):
        self.red = red
        self.green = green
        self.blue = blue

    def hex(self):
        """Return the color as a HTML/CSS hex code"""
        return "#%02x%02x%02x" % (255 * self.red,
                                  255 * self.green,
                                  255 * self.blue)
