# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""
Various base classes that didn't fir elsewhere
"""

__version__ = "$Revision: 1.1 $"

from Thuban.Lib.connector import Publisher

from messages import TITLE_CHANGED

class TitledObject:

    """Mix-in class for objects that have titles"""

    def __init__(self, title):
        self.title = title

    def Title(self):
        return self.title

    def SetTitle(self, title):
        self.title = title
        self.issue(TITLE_CHANGED, self)


class Modifiable(Publisher):

    """Class for objects maintaining a modified flag."""

    def __init__(self):
        self.modified = 0

    def WasModified(self):
        """Return true if the layer was modified"""
        return self.modified

    def UnsetModified(self):
        """Unset the modified flag"""
        self.modified = 0

    def changed(self, channel = None, *args):
        """Set the modified flag and issue a mesage on the given channel
        with arguments args. Call this method whenever anything has
        changed in a layer"""
        self.modified = 1
        if channel is not None:
            apply(self.issue, (channel, args))
