/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout.tools;

import de.intevation.printlayout.DocumentManager;
import de.intevation.printlayout.MatrixTools;
import de.intevation.printlayout.tools.OnScreenBox;
import de.intevation.printlayout.tools.Tool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.svg.SVGGraphicsElement;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.Overlay;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class PickingInteractor
extends InteractorAdapter
implements Overlay,
Tool {
    public static final String IDENTIFIER = "picking-tool";
    public static final TransformOperation TRANSLATE = new TransformOperation(){

        public void transform(String[] ids, DocumentManager documentManager, Point2D delta, Point2D orginal) {
            documentManager.translateIDs(ids, delta);
        }
    };
    public static final TransformOperation SCALE = new TransformOperation(){

        public void transform(String[] ids, DocumentManager documentManager, Point2D delta, Point2D orginal) {
            documentManager.scaleIDs(ids, delta, orginal);
        }
    };
    public static final TransformOperation ROTATE = new TransformOperation(){

        public void transform(String[] ids, DocumentManager documentManager, Point2D delta, Point2D orginal) {
            documentManager.rotateIDs(ids, delta, orginal);
        }
    };
    public static final int NO_DECORATION = 0;
    public static final int SCALE_DECORATION = 1;
    public static final int ROTATE_DECORATION = 2;
    public static final int MIN_DECORATION = 1;
    public static final int MAX_DECORATION = 2;
    protected boolean inUse;
    protected boolean finished;
    protected DocumentManager documentManager;
    protected ArrayList selected;
    protected ArrayList listeners;
    protected int startX;
    protected int startY;
    protected TransformOperation transformOperation;
    protected int decoration = 1;

    public PickingInteractor() {
    }

    public PickingInteractor(DocumentManager documentManager) {
        this.setDocumentManager(documentManager);
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void addPickingListener(PickingListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(5);
                this.listeners.add(listener);
            } else if (!this.listeners.contains(this.listeners)) {
                this.listeners.add(listener);
            }
        }
    }

    public void removePickingListener(PickingListener listener) {
        if (listener == null || this.listeners == null || !this.listeners.remove(listener) || this.listeners.isEmpty()) {
            // empty if block
        }
        this.listeners = null;
    }

    public String getToolIdentifier() {
        return IDENTIFIER;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public boolean startInteraction(InputEvent ie) {
        boolean start;
        if (!this.inUse) {
            return false;
        }
        boolean bl = start = ie instanceof MouseEvent && (ie.getModifiers() & 0x10) == 16;
        if (start) {
            this.finished = false;
        }
        return start;
    }

    public boolean endInteraction() {
        return this.finished;
    }

    protected static final boolean isShiftDown(int modifiers) {
        return (modifiers & 1) != 0;
    }

    protected static final boolean isCtrlDown(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public void mouseClicked(MouseEvent me) {
        this.finished = true;
        int modifiers = me.getModifiers();
        if ((modifiers & 0x10) != 16) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        String singleSelection = this.selected != null && this.selected.size() == 1 ? ((OnScreenBox)this.selected.get(0)).getID() : null;
        ArrayList result = this.query(x, y);
        int N = result.size();
        boolean changed = false;
        if (PickingInteractor.isCtrlDown(modifiers)) {
            if (N > 0) {
                Object last = result.get(N - 1);
                if (this.selected == null) {
                    this.selected = new ArrayList();
                    this.selected.add(last);
                    changed = true;
                } else if (!this.selected.contains(last)) {
                    this.selected.add(last);
                    changed = true;
                }
            }
        } else if (PickingInteractor.isShiftDown(modifiers)) {
            Object last;
            if (N > 0 && this.selected != null && this.selected.remove(last = result.get(N - 1))) {
                changed = true;
                if (this.selected.isEmpty()) {
                    this.resetSelection();
                }
            }
        } else {
            if (N > 0) {
                if (this.selected != null) {
                    this.selected.clear();
                } else {
                    this.selected = new ArrayList();
                }
                this.selected.add(result.get(N - 1));
            } else {
                this.resetSelection();
            }
            changed = true;
        }
        if (singleSelection != null && this.selected != null && this.selected.size() == 1 && ((OnScreenBox)this.selected.get(0)).getID().equals(singleSelection)) {
            this.advanceDecoration();
        }
        ((Component)me.getSource()).repaint();
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    protected void fireSelectionChanged() {
        if (this.listeners != null) {
            PickingEvent evt = new PickingEvent(this);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ((PickingListener)this.listeners.get(i)).selectionChanged(evt);
            }
        }
    }

    protected ArrayList query(int x, int y) {
        return this.query(x, y, true);
    }

    protected ArrayList query(int x, int y, boolean directlyInSheet) {
        AffineTransform xform;
        ArrayList<OnScreenBox> ordered = new ArrayList<OnScreenBox>();
        SVGDocument document = this.documentManager.getSVGDocument();
        SVGSVGElement sheet = (SVGSVGElement)document.getElementById("viewer-layout-sheet-svg");
        try {
            xform = MatrixTools.toJavaTransform(sheet.getScreenCTM().inverse());
        }
        catch (SVGException se) {
            se.printStackTrace();
            return ordered;
        }
        Point2D.Double screenPoint = new Point2D.Double(x, y);
        Point2D.Double documentPoint = new Point2D.Double();
        xform.transform(screenPoint, documentPoint);
        SVGRect query = sheet.createSVGRect();
        query.setX((float)((Point2D)documentPoint).getX() - 0.25f);
        query.setY((float)((Point2D)documentPoint).getY() - 0.25f);
        query.setWidth(0.5f);
        query.setHeight(0.5f);
        NodeList result = sheet.getIntersectionList(query, null);
        int N = result.getLength();
        for (int i = 0; i < N; ++i) {
            OnScreenBox box;
            AbstractElement parent;
            AbstractElement obj = (AbstractElement)result.item(i);
            String last = null;
            AbstractElement lastElement = null;
            while ((parent = (AbstractElement)obj.getParentNode()) != null) {
                String id = parent.getAttributeNS(null, "id");
                if (id != null && id.startsWith("viewer-layout-id")) {
                    last = id;
                    lastElement = parent;
                }
                if ((obj = parent) != null && obj != sheet) continue;
            }
            if (last == null || directlyInSheet && (lastElement == null || lastElement.getParentNode() != sheet) || ordered.contains(box = new OnScreenBox(last))) continue;
            ordered.add(box);
        }
        return ordered;
    }

    public void paint(Graphics g) {
        if (!this.inUse || this.selected == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(Color.red);
        SVGDocument document = this.documentManager.getSVGDocument();
        int BEFORE = this.selected.size();
        Rectangle damaged = new Rectangle();
        int i = 0;
        while (i < this.selected.size()) {
            OnScreenBox box = (OnScreenBox)this.selected.get(i);
            SVGGraphicsElement element = (SVGGraphicsElement)document.getElementById(box.getID());
            if (element == null) {
                this.selected.remove(i);
                continue;
            }
            ++i;
            SVGRect bbox = element.getBBox();
            SVGMatrix matrix = element.getScreenCTM();
            AffineTransform xform = MatrixTools.toJavaTransform(matrix);
            box.bbox2shape(bbox, xform);
            box.draw(g2d, damaged);
        }
        int NOW = this.selected.size();
        if (NOW == 1) {
            ((OnScreenBox)this.selected.get(0)).drawDecoration(g2d, this.decoration, damaged);
        }
        this.documentManager.getCanvas().damagedRegion(damaged);
        if (BEFORE != NOW) {
            if (NOW == 0) {
                this.resetSelection();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PickingInteractor.this.fireSelectionChanged();
                }
            });
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.transformOperation != null) {
            int x = e.getX();
            int y = e.getY();
            int dx = x - this.startX;
            int dy = y - this.startY;
            this.startX = x;
            this.startY = y;
            this.transformOperation.transform(this.getSelectedIDs(), this.documentManager, new Point2D.Double(dx, dy), new Point2D.Double(x, y));
        } else {
            this.finished = true;
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.finished = true;
    }

    public void mouseExited(MouseEvent e) {
        this.transformOperation = null;
        this.finished = true;
    }

    public void mouseMoved(MouseEvent e) {
        this.finished = true;
    }

    public void mousePressed(MouseEvent e) {
        OnScreenBox box;
        int inside = 0;
        int x = e.getX();
        int y = e.getY();
        for (int i = this.numSelections() - 1; i >= 0 && (inside = (box = (OnScreenBox)this.selected.get(i)).inside(x, y)) == 0; --i) {
        }
        if (inside != 0) {
            this.transformOperation = inside == 1 ? TRANSLATE : this.getTransformOperation();
            this.startX = e.getX();
            this.startY = e.getY();
        } else {
            this.finished = true;
        }
    }

    protected TransformOperation getTransformOperation() {
        switch (this.decoration) {
            case 1: {
                return SCALE;
            }
        }
        return ROTATE;
    }

    protected void advanceDecoration() {
        if (++this.decoration > 2) {
            this.decoration = 1;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseExited(e);
    }

    public int numSelections() {
        return this.selected == null ? 0 : this.selected.size();
    }

    public boolean hasSelection() {
        return this.selected != null && !this.selected.isEmpty();
    }

    public String[] getSelectedIDs() {
        if (!this.hasSelection()) {
            return null;
        }
        String[] ids = new String[this.selected.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((OnScreenBox)this.selected.get((int)i)).id;
        }
        return ids;
    }

    protected void resetSelection() {
        this.selected = null;
        this.decoration = 1;
    }

    public void clearSelection() {
        if (this.selected != null) {
            this.resetSelection();
            this.fireSelectionChanged();
        }
    }

    public static interface TransformOperation {
        public void transform(String[] var1, DocumentManager var2, Point2D var3, Point2D var4);
    }

    public static interface PickingListener {
        public void selectionChanged(PickingEvent var1);
    }

    public static class PickingEvent
    extends EventObject {
        public PickingEvent(Object source) {
            super(source);
        }
    }
}

