/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout.tools;

import de.intevation.printlayout.GeometricMath;
import de.intevation.printlayout.tools.Arrows;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.w3c.dom.svg.SVGRect;

public class OnScreenBox {
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int INSIDE_DECORATION = 2;
    protected String id;
    protected Shape shape;
    protected Point2D[] points;
    protected Shape[] decoration;
    public static final BasicStroke STROKE = new BasicStroke(2.0f);

    public OnScreenBox() {
    }

    public OnScreenBox(String id) {
        this.id = id;
    }

    protected int insideRect(int x, int y) {
        for (int i = 0; i < this.points.length; ++i) {
            double b;
            double ny;
            int j = (i + 1) % this.points.length;
            Point2D p1 = this.points[i];
            Point2D p2 = this.points[j];
            double dx = p1.getX() - p2.getX();
            double dy = p1.getY() - p2.getY();
            double nx = dy;
            if (!((double)x * nx + (double)y * (ny = -dx) + (b = -(nx * p1.getX() + ny * p1.getY())) > 0.0)) continue;
            return 0;
        }
        return 1;
    }

    public int inside(int x, int y) {
        if (this.points == null) {
            return 0;
        }
        if (this.decoration != null) {
            for (int i = 0; i < this.decoration.length; ++i) {
                if (!this.decoration[i].contains(x, y)) continue;
                return 2;
            }
        }
        return this.insideRect(x, y);
    }

    public boolean equals(Object other) {
        return this.id.equals(((OnScreenBox)other).id);
    }

    public String toString() {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    public void bbox2shape(SVGRect bbox, AffineTransform xform) {
        if (this.points == null) {
            this.points = new Point2D[4];
        }
        this.decoration = null;
        double x1 = bbox.getX();
        double y1 = bbox.getY();
        double x2 = x1 + (double)bbox.getWidth();
        double y2 = y1 + (double)bbox.getHeight();
        Point2D.Double src = new Point2D.Double(x1, y1);
        this.points[0] = new Point2D.Double();
        xform.transform(src, this.points[0]);
        src.y = y2;
        this.points[1] = new Point2D.Double();
        xform.transform(src, this.points[1]);
        src.x = x2;
        this.points[2] = new Point2D.Double();
        xform.transform(src, this.points[2]);
        src.y = y1;
        this.points[3] = new Point2D.Double();
        xform.transform(src, this.points[3]);
    }

    protected void buildDecoration(int type) {
        switch (type) {
            case 1: {
                this.buildScaleDecoration();
                break;
            }
            case 2: {
                this.buildRotateDecoration();
                break;
            }
            default: {
                this.decoration = null;
            }
        }
    }

    protected void buildScaleDecoration() {
        double ang1 = GeometricMath.angleBetween(this.points[0], this.points[2]);
        double ang2 = GeometricMath.angleBetween(this.points[1], this.points[3]);
        GeneralPath s1 = Arrows.createArrow(0.0, -11.0, ang1 + 1.5707963267948966, 1.0, this.points[0].getX(), this.points[0].getY());
        GeneralPath s2 = Arrows.createArrow(0.0, -11.0, ang2 + 1.5707963267948966, 1.0, this.points[1].getX(), this.points[1].getY());
        GeneralPath s3 = Arrows.createArrow(0.0, -11.0, ang1 + 4.71238898038469, 1.0, this.points[2].getX(), this.points[2].getY());
        GeneralPath s4 = Arrows.createArrow(0.0, -11.0, ang2 + 4.71238898038469, 1.0, this.points[3].getX(), this.points[3].getY());
        this.decoration = new Shape[]{s1, s2, s3, s4};
    }

    protected void buildRotateDecoration() {
        double ang1 = GeometricMath.angleBetween(this.points[0], this.points[2]);
        double ang2 = GeometricMath.angleBetween(this.points[1], this.points[3]);
        GeneralPath s1 = Arrows.createArrow(10.0, 0.0, ang1, 1.0, this.points[0].getX(), this.points[0].getY());
        GeneralPath s2 = Arrows.createArrow(10.0, 0.0, ang2, 1.0, this.points[1].getX(), this.points[1].getY());
        GeneralPath s3 = Arrows.createArrow(10.0, 0.0, ang1 - Math.PI, 1.0, this.points[2].getX(), this.points[2].getY());
        GeneralPath s4 = Arrows.createArrow(10.0, 0.0, ang2 - Math.PI, 1.0, this.points[3].getX(), this.points[3].getY());
        this.decoration = new Shape[]{s1, s2, s3, s4};
    }

    public void draw(Graphics2D g2d, Rectangle damaged) {
        if (this.points == null) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < this.points.length; ++i) {
            int j = (i + 1) % this.points.length;
            Point2D p1 = this.points[i];
            Point2D p2 = this.points[j];
            int p2x = (int)Math.round(p2.getX());
            int p2y = (int)Math.round(p2.getY());
            if (p2x < minX) {
                minX = p2x;
            }
            if (p2x > maxY) {
                maxX = p2x;
            }
            if (p2y < minY) {
                minY = p2y;
            }
            if (p2y > maxY) {
                maxY = p2y;
            }
            g2d.drawLine((int)Math.round(p1.getX()), (int)Math.round(p1.getY()), p2x, p2y);
        }
        damaged.add(new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1));
    }

    public void drawDecoration(Graphics2D g2d, int type, Rectangle damaged) {
        this.buildDecoration(type);
        for (int i = 0; i < this.decoration.length; ++i) {
            Shape deco = this.decoration[i];
            g2d.setPaint(Color.red);
            g2d.fill(deco);
            g2d.setPaint(Color.black);
            g2d.setStroke(STROKE);
            g2d.draw(deco);
            damaged.add(deco.getBounds());
        }
    }
}

