/*
 * Decompiled with CFR 0.152.
 */
package de.intevation.printlayout.tools;

import de.intevation.printlayout.DocumentManager;
import de.intevation.printlayout.MatrixTools;
import de.intevation.printlayout.tools.DrawingAttributes;
import de.intevation.printlayout.tools.Tool;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.apache.batik.dom.svg.SVGOMSVGElement;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGMatrix;

public class BoxInteractor
extends InteractorAdapter
implements Overlay,
Tool {
    public static final String IDENTIFIER = "box-tool";
    protected boolean inUse;
    protected boolean finished = true;
    protected DocumentManager documentManager;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;
    protected Paint strokeColor;
    protected Stroke stroke;
    protected Paint fillColor;
    protected float[] screenPoints;
    protected Factory factory;

    public String getToolIdentifier() {
        return IDENTIFIER;
    }

    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public void setScreenPoints(float x1, float y1, float x2, float y2) {
        float minX = Math.min(x1, x2);
        float maxX = Math.max(x1, x2);
        float minY = Math.min(y1, y2);
        float maxY = Math.max(y1, y2);
        this.screenPoints = new float[]{minX, minY, maxX, maxY};
    }

    public void clear() {
        this.screenPoints = null;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public void paint(Graphics g) {
        if (!this.inUse || this.factory == null) {
            return;
        }
        DrawingAttributes attributes = this.factory.getDrawingAttributes();
        Paint strokeColor = attributes.getStrokeColor();
        Stroke stroke = attributes.getStroke();
        Paint fillColor = attributes.getFillColor();
        SVGDocument document = this.documentManager.getSVGDocument();
        if (document != null && this.screenPoints != null && this.screenPoints.length == 4) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle2D.Float rect = new Rectangle2D.Float(this.screenPoints[0], this.screenPoints[1], this.screenPoints[2] - this.screenPoints[0], this.screenPoints[3] - this.screenPoints[1]);
            Shape shape = BoxInteractor.getXForm(document).createTransformedShape(rect);
            if (fillColor != null) {
                g2d.setPaint(fillColor);
                g2d.fill(shape);
            }
            g2d.setStroke(stroke);
            g2d.setPaint(strokeColor);
            g2d.draw(shape);
        }
    }

    protected static AffineTransform getXForm(SVGDocument document) {
        SVGOMSVGElement element = (SVGOMSVGElement)document.getElementById("viewer-layout-sheet-svg");
        SVGMatrix matrix = element.getCTM();
        return MatrixTools.toJavaTransform(matrix);
    }

    protected static AffineTransform getScreenXForm(SVGDocument document) {
        SVGOMSVGElement element = (SVGOMSVGElement)document.getElementById("viewer-layout-sheet-svg");
        SVGMatrix matrix = element.getScreenCTM();
        return MatrixTools.toJavaTransform(matrix);
    }

    public boolean startInteraction(InputEvent ie) {
        int mods = ie.getModifiers();
        return this.inUse && ie.getID() == 501 && (mods & 0x10) != 0;
    }

    public boolean endInteraction() {
        return this.finished;
    }

    public void mousePressed(MouseEvent e) {
        if (!this.finished) {
            this.mouseExited(e);
            return;
        }
        this.finished = false;
        this.xStart = e.getX();
        this.yStart = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.xCurrent = e.getX();
        this.yCurrent = e.getY();
        this.clear();
        JGVTComponent c = (JGVTComponent)e.getSource();
        this.consume();
        c.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.xCurrent = e.getX();
        this.yCurrent = e.getY();
        this.setScreenPoints(this.xStart, this.yStart, this.xCurrent, this.yCurrent);
        JGVTComponent c = (JGVTComponent)e.getSource();
        c.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.finished = true;
        this.clear();
        JGVTComponent c = (JGVTComponent)e.getSource();
        c.repaint();
    }

    protected void consume() {
        AffineTransform xform;
        if (this.factory == null) {
            return;
        }
        SVGDocument document = this.documentManager.getSVGDocument();
        float minX = Math.min(this.xStart, this.xCurrent);
        float maxX = Math.max(this.xStart, this.xCurrent);
        float minY = Math.min(this.yStart, this.yCurrent);
        float maxY = Math.max(this.yStart, this.yCurrent);
        Rectangle2D.Float rect = new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
        try {
            xform = BoxInteractor.getScreenXForm(document).createInverse();
        }
        catch (NoninvertibleTransformException nte) {
            nte.printStackTrace();
            return;
        }
        this.documentManager.modifyDocumentLater(this.factory.createBox(rect, xform));
    }

    public static interface Factory {
        public DocumentManager.DocumentModifier createBox(Rectangle2D var1, AffineTransform var2);

        public DrawingAttributes getDrawingAttributes();
    }
}

